
// blarg!
if( SERVER ) then
	// resources.
	resource.AddFile( "materials/themes/blue-plastic/close.vtf" );
	resource.AddFile( "materials/themes/blue-plastic/minus.vtf" );
	resource.AddFile( "materials/themes/blue-plastic/plus.vtf" );
	resource.AddFile( "materials/themes/blue-plastic/close.vmt" );
	resource.AddFile( "materials/themes/blue-plastic/minus.vmt" );
	resource.AddFile( "materials/themes/blue-plastic/plus.vmt" );
	resource.AddFile( "materials/themes/generic/resizer.vmt" );
	resource.AddFile( "materials/themes/generic/resizer.vtf" );

	return;
	
end

// Register a theme.
Theme	=	AppFramework:RegisterTheme( "Valve" );

// set colors
Theme.colors['window_face'] 	= Color( 120, 120, 120, 255 );
Theme.colors['title']		= Color( 255, 255, 255, 255 );
Theme.colors['text']		= Color( 255, 255, 255, 255 );
Theme.colors['window_face_sub']	= Color( 60, 60, 60, 255 );
Theme.colors['border_dark']	= Color( 42, 42, 42, 255 );
Theme.colors['button_face']	= Color( 140, 140, 140, 255 );
Theme.colors['border_light']	= Color( 196, 196, 196, 255 );
Theme.colors['selection']	= Color( 95, 127, 202, 70 );

// set icons
Theme.icons['close_button']	= "themes/valve/close";
Theme.icons['resizer']		= "themes/generic/resizer";
Theme.icons['plus_icon']	= "themes/blue-plastic/plus";
Theme.icons['minus_icon']	= "themes/blue-plastic/minus";

// set fonts.
Theme.fonts['title']		= "Default";
Theme.fonts['text']		= "DefaultSmall";

// theme draw frame.
function Theme:DrawFrame( x, y, width, height, draw_type, data )
	// remove any textures.
	draw.NoTexture();
	
	// window frame.
	if( draw_type == FRAME_WINDOW ) then
		// draw the valve frame using roundedbox.
		draw.RoundedBox(
			8,
			x, y,
			width, height,
			self.colors[data or 'window_face']
		);
		
	// inset frame
	elseif( draw_type == FRAME_INSET ) then
		// draw background
		if( data && type( data ) == "table" ) then
			surface.SetDrawColor(
				data.r,
				data.g,
				data.b,
				data.a
			);
		else
			surface.SetDrawColor(
				self.colors[data or 'window_face_sub'].r,
				self.colors[data or 'window_face_sub'].g,
				self.colors[data or 'window_face_sub'].b,
				self.colors[data or 'window_face_sub'].a
			);
		end
		surface.DrawRect(
			x + 2, y + 2,
			width - 4, height - 4
		);
		
		
		// draw dark borders
		surface.SetDrawColor(
			self.colors['border_dark'].r,
			self.colors['border_dark'].g,
			self.colors['border_dark'].b,
			self.colors['border_dark'].a
		);
		
		// top.
		surface.DrawLine(
			x + 2, y + 2, 
			x + width - 2, y + 2
		);
		
		// left
		surface.DrawLine(
			x + 2, y + 2,
			x + 2, y + height - 2
		);
		
		
		// draw light borders
		surface.SetDrawColor(
			self.colors['border_light'].r,
			self.colors['border_light'].g,
			self.colors['border_light'].b,
			self.colors['border_light'].a
		);
		
		// right
		surface.DrawLine(
			x + width - 2, y + 2,
			x + width - 2, y + height - 2
		);
		
		// bottom.
		surface.DrawLine(
			x + 2, y + height - 2,
			x + width - 2, y + height - 2
		);
		
	// outset frame
	elseif( draw_type == FRAME_OUTSET ) then
		// draw background
		if( data && type( data ) == "table" ) then
			surface.SetDrawColor(
				data.r,
				data.g,
				data.b,
				data.a
			);
		else
			surface.SetDrawColor(
				self.colors[data or 'window_face_sub'].r,
				self.colors[data or 'window_face_sub'].g,
				self.colors[data or 'window_face_sub'].b,
				self.colors[data or 'window_face_sub'].a
			);
		end
		surface.DrawRect(
			x + 2, y + 2,
			width - 4, height - 4
		);
		
		
		// draw dark borders
		surface.SetDrawColor(
			self.colors['border_light'].r,
			self.colors['border_light'].g,
			self.colors['border_light'].b,
			self.colors['border_light'].a
		);
		
		// top.
		surface.DrawLine(
			x + 2, y + 2, 
			x + width - 2, y + 2
		);
		
		// left
		surface.DrawLine(
			x + 2, y + 2,
			x + 2, y + height - 2
		);
		
		
		// draw light borders
		surface.SetDrawColor(
			self.colors['border_dark'].r,
			self.colors['border_dark'].g,
			self.colors['border_dark'].b,
			self.colors['border_dark'].a
		);
		
		// right
		surface.DrawLine(
			x + width - 2, y + 2,
			x + width - 2, y + height - 2
		);
		
		// bottom.
		surface.DrawLine(
			x + 2, y + height - 2,
			x + width - 2, y + height - 2
		);
	end
end

